// Adaptive menu
let autocollapse = function (menu, maxHeight) {

    let nav = jQuery(menu);
    let navHeight = nav.innerHeight();
    if (navHeight >= maxHeight) {

        jQuery(menu + ' .dropdown').removeClass('d-none');
        jQuery(".navbar-nav").removeClass('w-auto').addClass("w-100");

        while (navHeight > maxHeight) {
            //  add child to dropdown
            var children = nav.children(menu + ' li:not(:last-child)');
            var count = children.length;
            jQuery(children[count - 1]).prependTo(menu + ' .dropdown-menu');
            navHeight = nav.innerHeight();
        }
        jQuery(".navbar-nav").addClass("w-auto").removeClass('w-100');

    } else {

        let collapsed = jQuery(menu + ' .dropdown-menu').children(menu + ' li');

        if (collapsed.length === 0) {
            jQuery(menu + ' .dropdown').addClass('d-none');
        }

        while (navHeight < maxHeight && (nav.children(menu + ' li').length > 0) && collapsed.length > 0) {
            //  remove child from dropdown
            collapsed = jQuery(menu + ' .dropdown-menu').children('li');
            jQuery(collapsed[0]).insertBefore(nav.children(menu + ' li:last-child'));
            navHeight = nav.innerHeight();
        }

        if (navHeight > maxHeight) {
            autocollapse(menu, maxHeight);
        }

    }
};

jQuery(document).ready(function () {
    /**
     * Disabled because Main submenu disabled
     * */
    // autocollapse('#nav', 50);
    // jQuery(window).on('resize', function () {
    //     autocollapse('#nav', 50);
    // });

    /**
     * Search form
     */
    let btnDelete = document.getElementById('clear');
    let inputFocus = document.getElementById('inputFocus');
    let magicSearch = document.getElementById('magic-search');
    // btnDelete.on('click', function(e) {
    //   e.preventDefault();
    //   inputFocus.classList.add('isFocus')
    // })
    // inputFocus.addEventListener('click', function() {
    //   this.classList.add('isFocus')
    // })
    btnDelete.addEventListener('click', function (e) {
        e.preventDefault();
        inputFocus.value = ''
    })
    document.addEventListener('click', function (e) {
        if (document.getElementById('first').contains(e.target)) {
            inputFocus.classList.add('isFocus');
            magicSearch.classList.add('focus-search');
            inputFocus.focus();
        } else {
            // Clicked outside the box
            inputFocus.classList.remove('isFocus');
            magicSearch.classList.remove('focus-search');
        }
    });

    /**
     *
     */

    let dropdownSwitcher;
    let dropdownMenus = jQuery('.dropdown');

    function mobileScriptsToggle() {
        dropdownSwitcher = window.matchMedia('(max-width: 991px)').matches;
    }

    jQuery(window).on('resize', function () {
        mobileScriptsToggle();
        // dropdownMobileAnimation()
        // console.log(dropdownSwitcher);
    });

    mobileScriptsToggle();

    // Add slideDown animation to Bootstrap dropdown when expanding.
    dropdownMenus.on('show.bs.dropdown', function () {
        if (dropdownSwitcher) {
            jQuery(this).find('.dropdown-menu').first().stop(true, true).slideDown(215);
        }
        // else {
        //     jQuery(this).find('.dropdown-menu').first().stop(true, true);
        // }
    });

    // Add slideUp animation to Bootstrap dropdown when collapsing.
    dropdownMenus.on('hide.bs.dropdown', function () {
        if (dropdownSwitcher) {
            jQuery(this).find('.dropdown-menu').first().stop(true, true).slideUp(215, function () {
                jQuery(this).css('display', '');
            });
        }
        // else {
        //     jQuery(this).find('.dropdown-menu').first().stop(true, true);
        // }
    });


});
